iframe.onload = function(){
  try{
    var doc = iframe.contentDocument || iframe.contentWindow.document;
    var killer = doc.createElement('style');
    killer.textContent = '#ua-domtools, #ua-hilite-box{display:none!important}';
    doc.head.appendChild(killer);
    var dt=doc.getElementById('ua-domtools'); if(dt) dt.remove();
    var bx=doc.getElementById('ua-hilite-box'); if(bx) bx.remove();
    // ثم حقن picker.js كالمعتاد
    var s = doc.createElement('script'); s.src='admin.php?asset=picker.js';
    doc.head.appendChild(s);
  }catch(e){}
};



(function(){
  // ========= UI elements =========
  const hl=document.createElement('div');
  hl.style.cssText='position:fixed;z-index:999998;border:2px solid #2563EB;background:rgba(37,99,235,.08);pointer-events:none;display:none';
  const tip=document.createElement('div');
  tip.style.cssText='position:fixed;z-index:999999;background:#0b1220;color:#fff;font:12px/1.4 system-ui;padding:6px 8px;border-radius:8px;display:none';
  document.documentElement.appendChild(hl); document.documentElement.appendChild(tip);

  // ========= scroll lock helpers =========
  let lastScrollX = window.scrollX, lastScrollY = window.scrollY;
  const onScroll = ()=>{ lastScrollX = window.scrollX; lastScrollY = window.scrollY; };
  window.addEventListener('scroll', onScroll, {passive:true});

  // نمنع أي سلوك يسبب قفزة للصفحة
  const styleLock = document.createElement('style');
  styleLock.textContent = `
    html,body{ scroll-behavior:auto !important; }
    html{ overscroll-behavior:none !important; }
    *[href^="#"]{ cursor:default !important; }
  `;
  document.head.appendChild(styleLock);

  // ========= mode logic =========
  let curMode='inside';
  function modeFromKeys(e){ if(e.ctrlKey||e.metaKey) return 'replace'; if(e.altKey) return 'before'; if(e.shiftKey) return 'after'; return 'inside'; }
  function inferredModeFromPoint(el, e){
    // لو في مفاتيح تعديل، ناخدها. غير كده هنخمّن من مكان النقرة داخل البوكس.
    const k = modeFromKeys(e);
    if(k!=='inside') return k;
    const r = el.getBoundingClientRect();
    const relY = (e.clientY - r.top) / Math.max(1,r.height);
    if(relY < 0.33)  return 'before';
    if(relY > 0.67)  return 'after';
    return 'inside';
  }
  function modeLabel(m){ return m==='before'?'Insert BEFORE': m==='after'?'Insert AFTER': m==='replace'?'REPLACE element':'Insert INSIDE (append)'; }

  // ========= helpers =========
  function idx(el){let i=1;for(let s=el.previousElementSibling;s;s=s.previousElementSibling){ if(s.tagName===el.tagName) i++; } return i;}
  function xPath(el){ if(el.id) return '//*[@id="'+el.id+'"]'; const segs=[]; for(;el&&el.nodeType===1; el=el.parentElement){ segs.unshift(el.tagName.toLowerCase()+'['+idx(el)+']'); if(el.tagName.toLowerCase()==='html') break; } return '/'+segs.join('/'); }
  function cssPath(el){ const segs=[]; for(;el&&el.nodeType===1; el=el.parentElement){ segs.unshift(el.tagName.toLowerCase()+':nth-of-type('+idx(el)+')'); if(el.tagName.toLowerCase()==='html') break; } return segs.join(' > '); }

  function show(el, e){
    const r=el.getBoundingClientRect();
    curMode = inferredModeFromPoint(el, e);
    hl.style.display='block'; hl.style.left=r.left+'px'; hl.style.top=r.top+'px'; hl.style.width=r.width+'px'; hl.style.height=r.height+'px';
    tip.style.display='block'; tip.textContent = modeLabel(curMode)+'  •  '+el.tagName.toLowerCase()+(el.id?('#'+el.id):'');
    tip.style.left=(Math.max(6, Math.min(window.innerWidth-260, e.clientX+12)))+'px';
    tip.style.top=(Math.max(6, e.clientY+12))+'px';
  }
  function hide(){ hl.style.display='none'; tip.style.display='none'; }

  // ========= interactions =========
  document.addEventListener('mousemove',(e)=>{
    const t=e.target;
    if(t===document.documentElement||t===document.body){ hide(); return; }
    show(t,e);
  },{capture:true});

  document.addEventListener('mouseout',(e)=>{ if(!e.relatedTarget) hide(); },{capture:true});

  document.addEventListener('keydown',(e)=>{ /* تحديث فوري للـ tooltip */ 
    const el = document.elementFromPoint(
      Math.min(Math.max(0, (e.clientX||0)), window.innerWidth-1),
      Math.min(Math.max(0, (e.clientY||0)), window.innerHeight-1)
    );
    if(el && el.nodeType===1){ show(el, e); }
  },{capture:true});

  document.addEventListener('keyup',(e)=>{
    const el = document.elementFromPoint(
      Math.min(Math.max(0, (e.clientX||0)), window.innerWidth-1),
      Math.min(Math.max(0, (e.clientY||0)), window.innerHeight-1)
    );
    if(el && el.nodeType===1){ show(el, e); }
  },{capture:true});

  document.addEventListener('click',(e)=>{
    // امنع أي تصرّف افتراضي/روابط/فورمز
    e.preventDefault(); e.stopPropagation(); e.stopImmediatePropagation();

    // حافظ على موضع الصفحة تمامًا
    const preserve = ()=> window.scrollTo(lastScrollX, lastScrollY);
    preserve(); setTimeout(preserve, 0); setTimeout(preserve, 16);

    const el=e.target;
    const mode = inferredModeFromPoint(el, e);

    const payload={
      type:'UA_PICK',
      xpath:xPath(el),
      css:cssPath(el),
      id:el.id||'',
      mode: mode,
      // معلومات إضافية قد يستخدمها الباك إند لاحقًا
      point: { x: e.clientX, y: e.clientY },
      hint:  mode // before/after/inside based on pointer
    };
    hide();
    try{
      window.parent.postMessage(payload,'*');
    }finally{
      // تأكيد بصري سريع جوه الصفحة المختارة
      alert('✔️ Selected: ' + (el.tagName.toLowerCase() + (el.id?('#'+el.id):'')) + '\nMode: ' + mode.toUpperCase());
    }
  },{capture:true});

  document.addEventListener('keydown',(e)=>{ if(e.key==='Escape'){ hide(); window.parent.postMessage({type:'UA_PICK_CANCEL'},'*'); } },{capture:true});

  const header=document.createElement('div');
  header.style.cssText='position:fixed;left:6px;bottom:6px;z-index:1000000;background:#0b1220;color:#fff;padding:6px 8px;border-radius:8px;font:12px system-ui;opacity:.9';
  header.innerHTML='Click=auto-place (top=before, bottom=after, middle=inside) • Alt=before • Shift=after • Ctrl/Cmd=replace';
  document.documentElement.appendChild(header);
})();


tools.querySelector('#rgPick').addEventListener('click', function(){
  var pg = SETTINGS.pages[window.currentPageIndex];
  var url = (pg.php||'') + ((pg.php||'').indexOf('?')>-1?'&':'?') + 'ts=' + Date.now();

  var iframe = document.getElementById('pickerFrame');
  iframe.removeAttribute('name'); // تأكيد إنه مش ua_preview

  iframe.onload = function(){
    try{
      var doc = iframe.contentDocument || iframe.contentWindow.document;

      // منع/قتل أي DOMTools لو اتحمّل بالغلط
      var killer = doc.createElement('style');
      killer.textContent = '#ua-domtools, #ua-hilite-box{display:none!important}';
      doc.head.appendChild(killer);
      if (doc.defaultView) doc.defaultView.__UA_DOMTOOLS__ = false;
      var dt = doc.getElementById('ua-domtools'); if (dt) dt.remove();
      var bx = doc.getElementById('ua-hilite-box'); if (bx) bx.remove();

      // حقن سكربت الـ picker فقط
      var s = doc.createElement('script'); s.src='admin.php?asset=picker.js';
      doc.head.appendChild(s);
    }catch(e){}
  };

  iframe.src = url;
  if(window.bootstrap && document.querySelector('#modalPicker')){
    new bootstrap.Modal('#modalPicker').show();
  }else{
    toast('Picker modal not found','danger');
  }
});
